<?php
// Arvan Ping - Payment Request
$my_api_key = "ARVAN_PING_AUTH_9v3x_SECURE"; 

$input = file_get_contents('php://input');
$data = json_decode($input, true);

$api_key  = $data['api_key'] ?? '';
$amount   = $data['amount'] ?? 0;
$order_id = $data['order_id'] ?? '';

if ($api_key !== $my_api_key || empty($amount)) {
    die(json_encode(['error' => 'Unauthorized Access']));
}

$merchant_id = "82486468-258c-4691-a47e-1f1ed4672d82";

$params = [
    "merchant_id" => $merchant_id,
    "amount"      => (int)$amount,
    "currency"    => "IRT",
    "callback_url" => "https://pay.gameodin.ir/callback.php", 
    "description"  => $order_id,
    "metadata"     => ["order_id" => $order_id]
];

$curl = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
curl_setopt_array($curl, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($params),
    CURLOPT_HTTPHEADER => ['Content-Type: application/json']
]);
$result = json_decode(curl_exec($curl), true);
curl_close($curl);

if (isset($result['data']['authority'])) {
    $auth = $result['data']['authority'];
    if (!is_dir('logs')) { mkdir('logs', 0777, true); }
    file_put_contents("logs/auth_$auth.txt", json_encode(['amount' => $amount, 'order_id' => $order_id]));

    echo json_encode(["url" => "https://pay.gameodin.ir/invoice.php?authority=" . $auth]);
} else {
    echo json_encode(["error" => "Connection Error"]);
}